import { useQuery } from "@tanstack/react-query";

import { useFood } from "../UseFood";

function UseFoodCaloriesQuery(foodId: string) {
  const { getFoodCalories } = useFood();

  const queryData = useQuery({
    queryKey: ["foodCalories", foodId],
    queryFn: () => getFoodCalories(foodId),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseFoodCaloriesQuery;
