import { useQuery } from "@tanstack/react-query";

import { useSettings } from "../UseSettings";

interface Props {
  code: string;
}
function UseHomeItemsQuery({ code }: Props) {
  const { getHomeSellers } = useSettings();

  const queryData = useQuery({
    queryKey: ["homeItems", code],
    queryFn: () => getHomeSellers(code),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseHomeItemsQuery;
