import { keepPreviousData, useQuery } from "@tanstack/react-query";
import { orderData } from "@/src/types/general";
import { CHEF_LIST_PAGINATED_QUERY_KEY } from "@/src/constants/QueryKeys";
import { useChefs } from "../UseChefs";

interface Props {
  order: orderData;
  categoryID?: string;
  page?: number;
  title?: string;
  description?: string;
  paginate?: number;
  lat?: string;
  lng?: string
}
function UsePaginatedChefQuery({
  order,
  categoryID,
  page = 1,
  title,
  description,
  paginate,
  lat,
  lng
}: Props) {
  const { getPaginatedChefs } = useChefs();

  const queryData = useQuery({
    queryKey: [
      CHEF_LIST_PAGINATED_QUERY_KEY,
      order,
      categoryID,
      page,
      title,
      paginate,
      description,
      lat,
      lng
    ],
    queryFn: () =>
      getPaginatedChefs({
        order,
        categoryID,
        page,
        title,
        paginate,
        lat,
        lng
      }),
    placeholderData: keepPreviousData,
    refetchOnWindowFocus: false,
  });

  return queryData;
}

export default UsePaginatedChefQuery;
