import { useQuery } from "@tanstack/react-query";

import { useCategories } from "../UseCategories";

function UsePostCategoriesQuery() {
  const { getPostCategories } = useCategories();

  const queryData = useQuery({
    queryKey: ["postcategoriesList"],
    queryFn: () => getPostCategories(),
    staleTime: Infinity,
  });

  return queryData;
}

export default UsePostCategoriesQuery;
