import { useQuery } from "@tanstack/react-query";

import { useTicket } from "../UseTicket";

function UseTicketCategoriesQuery() {
  const { getTicketsCategories } = useTicket();

  const queryData = useQuery({
    queryKey: ["ticketCategoriesList"],
    queryFn: () => getTicketsCategories(),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseTicketCategoriesQuery;
