import { useQuery, UseQueryResult } from "@tanstack/react-query";
import { useCart } from "../UseCart";
import {
  ApiSetAddressByLocation,
  ServiceDetails,
} from "@/src/services/httpServices/CartServices/types";

export interface DeliveryNextAvailable {
  day: string;
  service_time_from: string;
  service_time_to: string;
  shipping_methods: string[];
  area_id: number;
}

export interface DeliveryMethod {
  id: number;
  title: string;
  is_address: boolean;
  description_text: string;
  description_required: boolean;
  description_error_text: string;
  is_active: boolean;
  message: string;
  created_at: string; // ISO timestamp
  updated_at: string; // ISO timestamp
  deleted_at: string | null;
  delivery_method: "restaurant" | string; // Extendable for other types if needed
}

export interface DeliveryError {
  error?: string;
  next_available?: DeliveryNextAvailable;
  delivery_methods?: DeliveryMethod[];
}
export interface DeliveryDetails {
  error?: string;
  next_available?: DeliveryNextAvailable;
  delivery_methods?: DeliveryMethod[];
}

function useDeliveryMethodByTime(
  params: ApiSetAddressByLocation | null
): UseQueryResult<DeliveryDetails, DeliveryError> {
  const { getDeliveryMethodByTime } = useCart();

  return useQuery<DeliveryDetails, DeliveryError>({
    queryKey: ["deliveryMethodByAddress", params],
    queryFn: () =>
      getDeliveryMethodByTime(params as ApiSetAddressByLocation),
    refetchOnWindowFocus: false,
  });
}

export default useDeliveryMethodByTime;
