import {
  createAddressService,
  deleteUserAddressByIdService,
  getAddressesForDeliveryTypeService,
  getAreasService,
  getUserAddressByIdService,
  getUserAddressService,
  getUserOrderAddressService,
  updateAddressService,
} from "@/src/services/httpServices/AddressServices";
import { ApiCreateAddress } from "@/src/services/httpServices/AddressServices/types";
import { Address, AreaFormOption } from "@/src/types/Address";
import { FormOption } from "@/src/types/general";

import { useState } from "react";

function UseAddress() {
  const [isLoading, setIsLoading] = useState(false);

  const createAddress = async (data: ApiCreateAddress) => {
    try {
      setIsLoading(true);
      await createAddressService(data);
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const deleteAddress = async (id: string) => {
    try {
      setIsLoading(true);
      await deleteUserAddressByIdService(id);
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const updateAddress = async (id: string, data: ApiCreateAddress) => {
    try {
      setIsLoading(true);
      await updateAddressService(id, data);
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getUserAddress = async (params?: {
    address_title?: string;
    address_area?: string;
  }) => {
    try {
      setIsLoading(true);
      const result = await getUserAddressService(params);
      const modeledData: Address[] = result.map((item) => ({
        address: item.address,
        id: item.id,
        title: item.title,
        plaque: item.plaque,
        postalCode: item.postal_code,
        unit: item.unit,
        lat: item.lat,
        lng: item.lng,
        phone: item.phone_number,
      }));
      return modeledData;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getUserAddressById = async (id: string) => {
    try {
      setIsLoading(true);
      const result = await getUserAddressByIdService(id);
      const modeledData: Address = {
        address: result.address,
        id: result.id,
        title: result.title,
        plaque: result.plaque,
        postalCode: result.postal_code,
        unit: result.unit,
        lat: result.lat,
        lng: result.lng,
        phone: result.phone_number,
        area: {
          parent: {
            label:
              result.area?.parent_id !== 0
                ? result.area
                  ? result.area.parent.title
                  : ""
                : result.area
                  ? result.area.title
                  : "",
            value:
              result.area?.parent_id !== 0
                ? result.area
                  ? result.area.parent.id
                  : ""
                : result.area
                  ? result.area.id
                  : "",
          },
          child: result.area?.parent_id
            ? {
                label: result.area.title,
                value: result.area.id,
              }
            : null,
        },
      };
      return modeledData;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getUserOrderAddress = async () => {
    try {
      setIsLoading(true);
      const result = await getUserOrderAddressService();
      const modeledData: FormOption[] = result.map((item) => ({
        value: item.id,
        label: item.title,
        description: item.address,
      }));
      return modeledData;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  const getUserOrderAddressByParam = async (params: {
    branch_id: number;
    delivery_type_id: number;
    user_id?: number;
    lat?: string;
    lng?: string;
  }) => {
    try {
      setIsLoading(true);

      // Build query object conditionally
      const queryParams: Record<string, string> = {
        branch_id: `${params.branch_id}`,
        delivery_type_id: `${params.delivery_type_id}`,
      };

      if (params.user_id !== undefined && params.user_id !== 0) {
        queryParams.user_id = `${params.user_id}`;
      }
      if (params.lat) {
        queryParams.lat = params.lat;
      }
      if (params.lng) {
        queryParams.lng = params.lng;
      }

      const result = await getAddressesForDeliveryTypeService(queryParams);
      const modeledData: FormOption[] = result.data.map((item) => ({
        value: item.id,
        label: item.title,
        isActive: item.is_active,
        description: item.address,
      }));

      return {
        modeledData,
        isLocationInActiveArea: result.is_location_in_active_area,
      };
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  const getAreas = async (parentId?: string) => {
    try {
      setIsLoading(true);
      const result = await getAreasService(parentId);
      const modeledData: AreaFormOption[] = result.map((item) => ({
        value: item.id,
        label: item.title,
        lat: item.lat,
        lng: item.lng,
      }));
      return modeledData;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  return {
    isLoading,
    createAddress,
    getUserAddress,
    getUserOrderAddress,
    getUserOrderAddressByParam,
    getUserAddressById,
    updateAddress,
    deleteAddress,
    getAreas,
  };
}

export default UseAddress;
