import {
  getFoodsService,
  getChefCategoriesFoodsService,
  getFoodCaloriesService,
} from "@/src/services/httpServices/FoodServices";
import { ApiProductPaginated } from "@/src/services/httpServices/FoodServices/types";
import { getPageComponentDataByCodeService } from "@/src/services/httpServices/SettingsServices";
import { CategoriesFood, FoodMenu, FoodParams } from "@/src/types/food";
import { OrderDataVariant, PaginationResult } from "@/src/types/general";
import { useEffect, useState } from "react";

function UseFood() {
  const [isLoading, setIsLoading] = useState(false);

 


  const getPaginatedFoods = async ({
    order = OrderDataVariant.ASC,
    categoryID,
    page,
    chefID,
    hasDiscount,
    title,
    location,
    prePage = 10,
  }: FoodParams) => {
    try {
      setIsLoading(true);
      const result = await getFoodsService({
        order_by: order,
        ...(categoryID && {
          category_id: categoryID,
        }),
        ...(title && {
          title,
        }),
        ...(chefID && {
          branch_id: chefID,
        }),
        ...(hasDiscount && {
          has_discount: hasDiscount && 1,
        }),
        ...(location?.lat &&
          location.lon && {
          ...location,
        }),
        page,
        paginate: prePage,
      });

      const modeledUser: PaginationResult<FoodMenu> = {
        currentPage: result.current_page,
        perPage: result.per_page,
        total: result.total,
        totalPages: result.last_page,

        data: result.data.map((item) => ({
          id: item.id,
          chefID: item.branch_id,
          varieties:
            item.varieties?.map((variety) => ({
              price: variety.price,
              varietyID: variety.id,
              title: variety.title,
              maxOrderLimit: +variety.max_order,
              discount: {
                percent: +variety.discount,
                discountedPrice: variety?.discounted_price ?? 0,
              },
              quantity: +variety.count,
            })) ?? [],
          Summary: item?.description ?? "",
          image: item.image,
          chefLogo: item.branch?.logo ?? "",
          title: item.title,
          description: item.description,

          calory: item.calory,
          gallery: item?.images
            ? item.images.map((image) => ({
              id: image.code,
              path: image.path,
            }))
            : [],

          rate: item.rate,
        })),
      };

      return modeledUser;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getChefCategoriesFoods = async (
    chefID: string,
    title?: string,
    day?: string,
    time?: string
  ) => {
    try {
      setIsLoading(true);
      const result = await getChefCategoriesFoodsService(
        chefID,
        title,
        day,
        time
      );
      const modeledData: CategoriesFood[] = result.map((item) => ({
        id: item.id,
        title: item.title,
        child_count:item.child_count || 0,
        image: item.img,
        foods: item.product_menu.map((product) => ({
          id: product.id,
          image: product.image,
          title: product.title,
          calory: product.calory,
          varieties: product.varieties.map((variety) => ({
            price: variety.price,
            varietyID: variety.id,
            title: variety.title,
            maxOrderLimit: +variety.max_order,
            quantity: +variety.count,
            discount: {
              percent: +variety.discount,
              discountedPrice: variety?.discounted_price ?? 0,
            },
          })),
          Summary: product.description ?? "",

          rate: product.rate,
          chefID: product.branch_id,

          gallery:
            product.images?.map((image) => ({
              id: image.code,
              path: image.path,
            })) ?? [],
        })),
      }));

      return modeledData;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  const getFoodCalories = async (foodId: string) => {
    try {
      setIsLoading(true);
      const result = await getFoodCaloriesService(foodId);

      return result;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getFoodsWithCode = async (code: string) => {
    // Retrieve lat and lng directly from localStorage each time the function is called
    let lat: string | undefined;
    let lng: string | undefined;

    try {
      const unsavedAddress = localStorage.getItem("unsavedAddress");
      if (unsavedAddress) {
        const addressData = JSON.parse(unsavedAddress);
        lat = addressData?.lat;
        lng = addressData?.lng;
      }
    } catch (error) {
      console.error("Error parsing unsavedAddress:", error);
    }

    try {
      setIsLoading(true);

      // Call your API with the lat and lng values if they exist
      const result = await getPageComponentDataByCodeService<ApiProductPaginated>(
        code,
        {
          ...(lat ? { lat } : {}),
          ...(lng ? { lng } : {})
        }
      );

      const modeledUser: PaginationResult<FoodMenu> = {
        currentPage: result.current_page,
        perPage: result.per_page,
        total: result.total,
        totalPages: result.last_page,

        data: result.data.map((item) => ({
          id: item.id,
          chefID: item.branch_id,
          varieties: item.varieties?.map((variety) => ({
            price: variety.price,
            varietyID: variety.id,
            title: variety.title,
            maxOrderLimit: +variety.max_order,
            discount: {
              percent: +variety.discount,
              discountedPrice: variety?.discounted_price ?? 0,
            },
            quantity: +variety.count,
          })) ?? [],
          Summary: item?.description ?? "",
          image: item.image,
          chefLogo: item.branch?.logo ?? "",
          title: item.title,

          calory: item.calory,
          gallery: item?.images
            ? item.images.map((image) => ({
              id: image.code,
              path: image.path,
            }))
            : [],

          rate: item.rate,
        })),
      };

      return modeledUser;
    } catch (error) {
      console.error("Error in getFoodsWithCode:", error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  return {
    isLoading,
    getPaginatedFoods,
    getChefCategoriesFoods,
    getFoodCalories,
    getFoodsWithCode,
  };
}

export default UseFood;
