"use client";

import React from "react";
import { SnackbarProvider as SnackbarProviderContainer } from "notistack";

interface SnackbarProviderProps {
  children: React.ReactNode;
}

export default function SnackbarProvider({ children }: SnackbarProviderProps) {
  return (
    <SnackbarProviderContainer
      autoHideDuration={2500}
      anchorOrigin={{
        horizontal: "right",
        vertical: "bottom",
      }}
    >
      {children}
    </SnackbarProviderContainer>
  );
}
