import { apiEndpoints } from "@/src/constants/Endpoints";
import { httpService } from "../httpService";
import { ApiCategory } from "./types";
import { ApiPostCategory } from "../PostServices/types";

const { category } = apiEndpoints;

export const getCategoriesService = (params?: {
  branch_id?: string;
  lat?:string;
  lng?:string
}): Promise<ApiCategory[]> => httpService.get(category.base, { params });
export const getPostCategoriesService = (): Promise<ApiPostCategory[]> =>
  httpService.get(category.postCategory);
