import { WeekType } from "@/src/types/Chef";
import {
  ApiFile,
  ApiFormOption,
  ApiPaginationResult,
  ApiTimeStampData,
  orderData,
} from "@/src/types/general";

export interface ApiAvailableTime extends ApiTimeStampData {
  id: number;
  to_time: string;
  from_time: string;
  week_day: WeekType;
  branch_id: number;
}
export interface ApiChefGallery extends ApiTimeStampData {
  id: string;
  title: string;
  files: ApiFile[];
}
export interface ApiVendor extends ApiTimeStampData {
  id: number;
  title: string;
  slug: string;
  sub_domain: string;
  user_id: number;
}
export interface ApiBranch extends ApiTimeStampData {
  id: string;
  title: string;
  address: string;
  lat: string;
  lng: string;
  main_branch: boolean;
  category_id: number;
  area_id: number;
  vendor_id: number;
  vendor: ApiVendor;
  min_order: number;
  description: string;
  sm_description: string;
  logo: string;
  cover: string;
  products_count: number;
  products_with_variety_avg_price: number;
  per_order_status: boolean;
  nearest_opening_hour: ApiAvailableTime;
  area: {
    id: string;
    title: string;
  };
  rate: string;
  status: string;
}
export type ApiChefPaginated = ApiPaginationResult<ApiBranch>;
export interface ApiChefParams {
  order_by: orderData;
  per_page: number;
  page: number;

  title?: string;
  category_id?: string;
}
export interface ApiAvailableTimeList {
  monday: ApiAvailableTime[] | null;
  tuesday: ApiAvailableTime[] | null;
  wednesday: ApiAvailableTime[] | null;
  thursday: ApiAvailableTime[] | null;
  friday: ApiAvailableTime[] | null;
  saturday: ApiAvailableTime[] | null;
  sunday: ApiAvailableTime[] | null;
}
export interface ApiChefRegistration {
  name: string;
  family: string;
  mobile: string;
  national_code: string;
  birthday?: string;
  referral_code?: string;
  user_name?: string;
  address: string;
  tel: string;
  socials: ApiFormOption[];
}
export interface ApiBranchPreOrder {
  [day: string]: string[];
}
