import { apiEndpoints } from "@/src/constants/Endpoints";
import { httpService } from "../httpService";
import {
  ApiAddFavorite,
  ApiBranchFavoritesItem,
  ApiProductFavoritesItem,
} from "./types";

const { favorite } = apiEndpoints;
export const addItemToFavoritesService = (data: ApiAddFavorite) =>
  httpService.post(favorite.add, data);
export const removeItemToFavoritesService = (data: ApiAddFavorite) =>
  httpService.delete(favorite.remove, {
    data,
  });
export const FavoritesStatusService = (data: ApiAddFavorite) =>
  httpService.get(favorite.status, {
    params: data,
  });
export const getFavoritesChefsService = (): Promise<ApiBranchFavoritesItem[]> =>
  httpService.get(favorite.branch);
export const getFavoritesProductsService = (): Promise<
  ApiProductFavoritesItem[]
> => httpService.get(favorite.products);
