import { apiEndpoints } from "@/src/constants/Endpoints";
import { httpService } from "../httpService";
import {
  ApiHomePage,
  ApiPageItem,
  ApiSlider,
  SliderType,
  ApiPage,
  ApiSettings,
  ApiHomeItem,
  ApiComponents,
} from "./types";

const { settings, pages, components } = apiEndpoints;

export const getHomePagesService = (): Promise<ApiHomePage> =>
  httpService.get(settings.homePage, undefined, false);
export const getSiteSettingsService = (): Promise<ApiSettings> =>
  httpService.get(settings.siteSettings, undefined, false);
export const getHomePageSliderService = (
  type: SliderType,
  lat?:string , lng?:string
): Promise<ApiSlider[]> =>
  httpService.get(settings.slider, {
    params: {
      type,
      lat,lng
    },
  });
export const getPagesService = (): Promise<ApiPageItem[]> =>
  httpService.get(pages.base);
export const getPageService = (slug: string): Promise<ApiPage> =>
  httpService.get(`${pages.show}${slug}`);
export const getSiteLogoService = (): Promise<string> =>
  httpService.get(settings.logo, undefined, false);
export const getSiteItemsService = (): Promise<ApiHomeItem[]> =>
  httpService.get(settings.homeInfo);

export const getPageComponentsBySlugService = (
  slug: string,
  params?: { lat?: string; lng?: string }
): Promise<ApiComponents[]> =>
  httpService.get(`${components.getMainComponents}${slug}`, { params });

export const getPageComponentDataByCodeService = <T>(
  code: string,
  params?: { lat?: string; lng?: string }
): Promise<T> => httpService.get(`${components.getData}${code}`, { params });
 