import { apiEndpoints } from "@/src/constants/Endpoints";
import { ApiPaginationResult } from "@/src/types/general";
import { httpService } from "../httpService";
import {
  ApiBaseTicket,
  ApiTicketCategory,
  ApiTicketItem,
  ApiTicketParams,
} from "./types";

const { ticket } = apiEndpoints;
export const createTicketService = (data: ApiBaseTicket) =>
  httpService.post(ticket.create, data);
export const userTicketService = (
  params: ApiTicketParams
): Promise<ApiPaginationResult<ApiTicketItem>> =>
  httpService.get(ticket.base, {
    params,
  });
export const getTicketCategoriesService = (): Promise<ApiTicketCategory[]> =>
  httpService.get(ticket.category);
export const showTicketService = (ticketId: string): Promise<ApiTicketItem> =>
  httpService.get(`${ticket.show}/${ticketId}`);
