import { apiEndpoints } from "@/src/constants/Endpoints";
import { ApiPaginationResult } from "@/src/types/general";
import { httpService } from "../httpService";
import { ApiTransactionItem } from "./types";

const {
  user: { getUserTransactions },
} = apiEndpoints;

export const getUserTransactionService = (params: {
  page: number;
  paginate: number;
}): Promise<ApiPaginationResult<ApiTransactionItem>> =>
  httpService.get(getUserTransactions, {
    params,
  });
