import { FormOption } from "./general";

export interface AreaFormOption extends FormOption {
  lat: string;
  lng: string;
  title?:string
}
export interface Address {
  id: string;
  title: string;
  address: string;
  plaque: string;
  postalCode: string;
  phone?: string;
  unit: string;
  lat: string;
  lng: string;
  area?: {
    parent: FormOption;
    child: FormOption | null;
  };
}

export interface AddressForm {
  title: string;
  lat?: string;
  lng?: string;
  address: string;
  area: {
    parent: AreaFormOption;
    child: AreaFormOption | null;
  };

  phone: string;
}
