import { StaticImageData } from "next/image";
import { CSSProperties, ReactNode } from "react";
import { SkeletonProps } from "react-loading-skeleton";
import { ClassNameValue } from "tailwind-merge";
import { Icon } from "iconsax-react";
import { FavoriteType } from "./Favorite";

export type ProfileItems =
  | "wallet"
  | "info"
  | "address"
  | "order"
  | "tickets"
  | "favorites"
  | "discounts"
  | "transactions";
export type OrderItems = "current" | "delivered" | "wating_payment";
export interface BaseMenuItem {
  icon?: ReactNode | Icon;
  title: string;
}
export interface MenuItem extends BaseMenuItem {
  link: string;
  multiVendorExclusive?: boolean;
}
export interface ProfileMenuItem extends BaseMenuItem {
  id: ProfileItems;
  description?: string;
}
export interface OrderMenuItem extends BaseMenuItem {
  id: OrderItems;
}
export interface FavoriteMenuItem extends BaseMenuItem {
  id: FavoriteType;
}
export interface DefaultApiResponse {
  data: {
    message: string;
  };
}
export interface ApiPaginationResult<T> {
  data: T[];
  current_page: number;
  first_page_url: string;
  from: string;
  last_page: number;
  last_page_url: string;
  next_page_url: string;
  path: string;
  per_page: string;
  prev_page_url: string;
  to: number;
  total: number;
}
export interface ApiTimeStampData {
  created_at?: Date;
  updated_at?: Date;
  deleted_at?: Date;
}
export interface PaginationResult<T> {
  data: T[];
  currentPage: number;
  perPage: string;
  total: number;
  totalPages: number;
}
export enum OrderDataVariant {
  ASC = "asc",
  DESC = "desc",
  RATE = "rate",
}
export type orderData =
  (typeof OrderDataVariant)[keyof typeof OrderDataVariant];
export interface File {
  id: string;
  path: string;
}
export interface LinkFile extends File {
  link: string;
}
export interface ApiFile {
  id: string;
  code: string;
  path: string;
}
export interface NextImageProps {
  src: string | StaticImageData;
  alt: string;
  skeletonProps?: SkeletonProps;
  imgWrapperClassName?: ClassNameValue;
  imgClassName?: ClassNameValue;
  imgStyles?: CSSProperties;
  imgWrapperStyles?: CSSProperties;
  objectFit?: "cover" | "contain";
  width?: number;
  height?: number;
  debug?: string;
  customFallback?: string;
  fill?: boolean;
  priority?: boolean;
}
export interface FormOption {
  value: string;
  label: string;
  description?: string;
}
export interface ApiFormOption {
  name: string;
  link: string;
}
export type orderResultMode = "order" | "wallet";

export interface Settings {
  mode: "single" | "multiVendor";
  singleModeBranch?: string;
  scripts: string;
  logo: string;
  smDescription: string;
  title: string;
  enamadCode: string;
  eata: string;
  sorosh: string;
  instagram: string;
  telegram: string;
  whatsapp: string;
  headerTelephoneSupport: string;
  headerTextSupport: string;
  forceMap: boolean;
  privacyRoute: string;
  authBg: string;
  loader: string;
  emptyProductImage:string
}
export interface SettingsStore {
  settings: Settings;
  setSettings: (settings: Settings) => void;
  resetSettings: () => void;
}
export type SingleRestaurantTabs = "menu" | "info";
export interface ApiSitemapItems {
  id: string;
  title: string;
}
export interface ApiSitemap {
  products: ApiSitemapItems[];
  branches: ApiSitemapItems[];
}
